//Digital Simulation of P, PI, PD, and PID controllers
//Scilab Version 5.5.2 ; OS:Windows

//Program for Open Loop control system
num=poly([20],'s','coeff');//Numerator input
den=poly([30 20 2],'s','coeff');//Denominator input
q=syslin('c',num/den)//Ratio of the numerator to the denominator
t=0:0.05:2.5;//time interval
p=csim('step',t,q);
subplot(221)
plot2d(t,p);
xlabel('Time(Sec)')
ylabel('Amplitude')
xtitle('Digital Simulation of Open Loop control system')

// Program for P Controller 
kp=250;
num=poly([kp],'s','coeff');
den=poly([30+kp 20 2],'s','coeff');
q=syslin('c',num/den)
t=0:0.01:2;
p=csim('step',t,q);
subplot(222)
plot2d(t,p,style=color("red"));
xlabel('Time(Sec)')
ylabel('Amplitude')
xtitle('Digital Simulation of P Controller')

// Program for PI Controller
kp=40;
ki=80;
num=poly([ki kp],'s','coeff');
den=poly([ki 30+kp 20 2],'s','coeff');
q=syslin('c',num/den)
t=0:0.01:2;
p=csim('step',t,q);
subplot(223)
plot2d(t,p,style=color("blue"));
xlabel('Time(Sec)')
ylabel('Amplitude')
xtitle('Digital Simulation of PI Controller') 

// Program for PID Controller
kp=400;
kd=70;
ki=400;
num=poly([ki kp kd],'s','coeff');
den=poly([ki 30+kp 20+kd 2],'s','coeff');
q=syslin('c',num/den)
t=0:0.01:2;
p=csim('step',t,q);
subplot(224)
plot2d(t,p,style=color("green"));
xlabel('Time(Sec)')
ylabel('Amplitude')
xtitle('Digital Simulation of PID Controller') 
